<?php
/**
 * Global Configuration Override
 *
 * You can use this file for overriding configuration values from modules, etc.
 * You would place values in here that are agnostic to the environment and not
 * sensitive to security.
 *
 * @NOTE: In practice, this file will typically be INCLUDED in your source
 * control, so do not include passwords or other sensitive information in this
 * file.
 */
return array(
    'environment' => getenv('KOTKA_ENV') ?: 'production',
    'pdf_converted' => getenv('PDF_TO_HTML'),
    'imageserver' => array(
        'server_location' => getenv('IMAGE_API_SERVER'),
        'system' => getenv('IMAGE_API_USERNAME'),
        'username' => getenv('IMAGE_API_USERNAME'),
        'password' => getenv('IMAGE_API_PASSWORD'),
    ),
    'elastic' => array(
        'client' => array(
            'sniffOnStart' => false,
            'hosts' => array(
                getenv('ELASTICSEARCH') ?: '127.0.0.1:9200',
            )
        )
    ),
    'service_manager' => array(
        'abstract_factories' => array(
            'Zend\Db\Adapter\AdapterAbstractServiceFactory',
        ),
    ),
    'excel' => array(
        'directory' => 'data/generated_excels',
    ),
    'search' => array(
        'export_dir' => 'data/generated_excels',
    ),
    'auth' => array(
        'userClass' => '\Kotka\Triple\MAPerson'
    ),
    'session_config' => array(
        'name' => 'KOTKA_ID',
        'remember_me_seconds' => 432000,
        'cookie_lifetime' => 0,
        'use_cookies' => true,
        'cookie_httponly' => true,
        'cookie_secure' => false
    ),
);
