<?php

namespace Api\Service;

use Common\Service\IdService;
use Kotka\Service\FormElementService;

class ImageService {
    private $imageService;
    private $formElementService;
    private $digitariumUrl;

    public function __construct(\ImageApi\Service\ImageService $imageService, FormElementService $formElementService, $digitariumUrl)
    {
        $this->imageService = $imageService;
        $this->formElementService = $formElementService;
        $this->digitariumUrl = $digitariumUrl;
    }

    public function getImages($id, $skipSecret = true) {
        $id = IdService::getQName($id);
        $images = $this->imageService->getImages(IdService::getUri($id));
        $pics = $this->imageService->convertMediaArrayToOldApi(
            $images,
            $id,
            $this->formElementService->getSelect('MZ.intellectualRights', []),
            $skipSecret
        );

        $qname = array_pop(explode(':',$id));
        if (strpos($qname, 'F.') === 0 || strpos($qname, 'E') === 0 || strpos($qname, 'H.') === 0 || strpos($qname, 'C.') === 0) {
            $ctx = stream_context_create(array('http'=>
                array(
                    'timeout' => 3,
                )
            ));
            $digitarium = json_decode(file_get_contents(sprintf($this->digitariumUrl, $qname), false, $ctx), true);
            if (is_array($digitarium)) {
                foreach ($digitarium as $key => $imgs) {
                    $pics[$key]['num_images'] += $imgs['num_images'];
                    if (!isset($imgs['images'])) {
                        continue;
                    }
                    if (!isset($pics[$key]['images'])) {
                        $pics[$key]['images'] = array();
                    }
                    foreach ($imgs['images'] as $img) {
                        $pics[$key]['images'][] = $img;
                    }
                }
            }
        }
        return $pics;
    }
}