<?php
namespace Kotka\DataGrid;

use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class TransactionGridFactory implements FactoryInterface
{
    /**
     * @see \Zend\ServiceManager\FactoryInterface::createService()
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $organizationService = $serviceLocator->get('Kotka\Service\OrganizationService');
        $formElementService = $serviceLocator->get('Kotka\Service\FormElementService');

        $class = new TransactionGrid($organizationService, $formElementService);
        $class->setGrid($serviceLocator->get('zfcDatagrid'));

        return $class;
    }
}