<?php
namespace Kotka\Form;

use Kotka\Stdlib\Hydrator\Reflection;
use Kotka\Stdlib\Hydrator\Strategy\DateTimeStrategy;
use Kotka\Triple\HRAPermit as Permit;
use KotkaConsole\Generator\Form\Template\HRATransaction as Transaction;
use Zend\Form\Fieldset;

/**
 * Class HRAPermit
 * @package Kotka\Form
 */
class HRAPermit extends Fieldset
{

    /**
     * Creates the form with all the necessary fields in it
     */
    public function init()
    {
        parent::init();
        $this
            ->setHydrator(new Reflection())
            ->setObject(new Permit());
    }

    public function postInit()
    {
        //$this->remove('subject');
        $dateStrategy = new DateTimeStrategy();
        $dateStrategy->setOptions(array(
            'format' => Transaction::DATE_FORMAT
        ));
        $this->hydrator->addStrategy('HRAPermitStartDate', $dateStrategy);
        $this->hydrator->addStrategy('HRAPermitEndDate', $dateStrategy);
    }
}