<?php

namespace Kotka\Form;

use Kotka\Stdlib\Hydrator\Reflection;
use Kotka\Stdlib\Hydrator\Strategy\DateTimeStrategy;
use Kotka\Triple\PUUEvent as Event;
use Zend\Form\Form;
use Zend\InputFilter\InputFilterProviderInterface;

/**
 * Class PUUEvent
 * @package Kotka\Form
 */
class PUUEvent extends Form implements InputFilterProviderInterface
{

    /**
     * Creates the form with all the necessary fields in it
     */
    public function init()
    {
        $this
            ->setHydrator(new Reflection())
            ->setObject(new Event());
    }

    public function postInit()
    {
        $this->remove('subject');
        $dateStrategy = new DateTimeStrategy();
        $dateStrategy->setOptions(array(
            'format' => 'Y-m-d'
        ));
        $this->hydrator->addStrategy('PUUDate', $dateStrategy);
    }

    /**
     * Should return an array specification compatible with
     * {@link Zend\InputFilter\Factory::createInputFilter()}.
     *
     * @return array
     */
    public function getInputFilterSpecification()
    {
        return array(
            'PUUDate' => array(
                'required' => false,
                'filters' => array(
                    array(
                        'name' => 'Null',
                    )
                ),
                'validators' => array(
                    array(
                        'name' => 'date',
                        'break_chain_on_failure' => true,
                        'options' => array(
                            'format' => 'Y-m-d',
                        )
                    )
                )
            ),
            'PUUBranchID' => array(
                'require' => true
            )
        );
    }
}
