<?php

namespace Kotka\InputFilter;


use Zend\InputFilter\CollectionInputFilter;

class MFSample extends TripleStoreInputFilter
{
    public function init()
    {

        $inDbEnum = [
            'MFElutionMedium' => 'MF.elutionMedium',
            'MFIndividualsInPreparation' => 'MF.individualsInPreparation',
            'MFMaterial' => 'MF.material',
            'MFQualityCheckMethod' => 'MF.qualityCheckMethod',
            'MFStatus' => 'MY.status',
            'MFPreparationType' => 'MF.preparationType',
            'MFQuality' => 'MF.quality',
            'MFPreservation' => 'MY.preservation',
        ];

        foreach ($inDbEnum as $field => $db) {
            $this->add(array(
                'name' => $field,
                'required' => false,
                'filters' => array(
                    array(
                        'name' => 'PrefixFilter',
                        'options' => array(
                            'prefix' => $db
                        )
                    ),
                    array(
                        'name' => 'NormalizeDatabaseSelect',
                        'options' => array(
                            'field' => $db
                        )
                    )
                ),
                'validators' => array(
                    array(
                        'name' => 'InDatabaseSelect',
                        'options' => array(
                            'field' => $db
                        )
                    )
                )
            ));
        }

        $this->add(array(
            'name' => 'MFCollectionID',
            'required' => false,
            'filters' => array(
                array(
                    'name' => 'ToQName'
                )
            ),
            'validators' => array(
                array(
                    'name' => 'InDatabaseSelect',
                    'options' => array(
                        'field' => 'MY.collectionID'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'MFDatasetID',
            'required' => false,
            'filters' => array(
                array(
                    'name' => 'ForceArray',
                ),
                array(
                    'name' => 'EmptyArray',
                ),
                array(
                    'name' => 'ToQName'
                ),
            ),
            'validators' => array(
                array(
                    'name' => 'InDatabaseSelect',
                    'options' => array(
                        'field' => 'MY.datasetID'
                    )
                )
            )
        ));

        $subFilter = $this
            ->getServiceLocator()
            ->getServiceLocator()
            ->get('InputFilterManager')
            ->get('Kotka\InputFilter\MYMeasurement');
       // $this->add($subFilter, 'MYMeasurement');

        $subFilter = $this
            ->getServiceLocator()
            ->getServiceLocator()
            ->get('InputFilterManager')
            ->get('Kotka\InputFilter\MFPreparation');
        $subCollectionInputFilter = new CollectionInputFilter();
        $subCollectionInputFilter->setInputFilter($subFilter);
        $this->add($subCollectionInputFilter, 'MFPreparation');

        parent::init();
    }
}