<?php

namespace KotkaConsole\Generator\Form\Template;

/**
 * Class PUUBranch
 * @package KotkaConsole\Generator\Form\Template
 */
class PUUEvent extends Base
{

    protected $base = 'Kotka\Form\PUUEvent';

    public function __construct()
    {

        $this->add(array(
            'name' => 'PUUBranchID',
            'type' => 'hidden',
        ));

        $this->add(array(
            'name' => 'PUULifeStage',
            'type' => 'hidden',
            'options' => array(
                'empty_option' => '',
                'field' => 'PUU.lifeStage'
            )
        ));

        $this->add(array(
            'name' => 'PUUEventType',
            'type' => 'DatabaseSelect',
            'options' => array(
                'empty_option' => '',
                'field' => 'PUU.eventType'
            )
        ));

        $this->add(array(
            'name' => 'PUUDate',
            'type' => 'text',
            'attributes' => array(
                'id' => 'transactionSent',
                'type' => 'text',
                'data-date-format' => 'YYYY-MM-DD',
                'data-date-autoclose' => 'true',
                'data-date-max-date' => 'now',
                'data-date-use-current' => 'day',
            ),
            'options' => array(
                'template' => 'kotka/partial/element/datetime-picker',
            )
        ));

        $this->add(array(
            'name' => 'PUUAgent',
            'type' => 'DatabaseSelect',
            'options' => array(
                'empty_option' => 'Select',
                'field' => 'MA.person-known',
                'template' => 'kotka/partial/element/select2'
            )
        ));

        $this->add(array(
            'name' => 'PUUNotes',
            'type' => 'textarea'
        ));
    }
}
