<?php
namespace Kotka\Form;

use Kotka\Stdlib\Hydrator\Strategy\DateTimeStrategy;
use KotkaConsole\Generator\Form\Template\HRATransaction as Transaction;

/**
 * Class HRATransaction
 * @package Kotka\Form
 */
class HRATransaction extends WarningForm
{

    public function init()
    {
        parent::init();
    }

    public function postInit()
    {
        $dateStrategy = new DateTimeStrategy();
        $dateStrategy->setOptions(array(
            'format' => Transaction::DATE_FORMAT
        ));
        $this->hydrator->addStrategy('HRATransactionRequestReceived', $dateStrategy);
        $this->hydrator->addStrategy('HRAGeneticResourceAcquisitionDate', $dateStrategy);
        $this->hydrator->addStrategy('HRATransactionSent', $dateStrategy);
        $this->hydrator->addStrategy('HRADueDate', $dateStrategy);
        $this->hydrator->addStrategy('HRATransactionReturned', $dateStrategy);
        $this->hydrator->addStrategy('HRAReceiptReturned', $dateStrategy);

        $prep = $this->get('HRAPermit');
        $target = $prep->getTargetElement();
        $target->postInit();
    }

    public function addMetaFields()
    {
        $this->add(array(
            'name' => 'subject',
            'type' => 'text',
        ),
            array(
                'priority' => 1003,
            ));

        $this->add(array(
            'name' => 'MYNamespaceID',
            'type' => 'text',
            'attributes' => array(
                'id' => 'namespaceID',
                'placeholder' => 'Namespace ID',
            ),
            'options' => array(
                'label' => 'Namespace ID',
                'help' => "Namespace of the transaction HRA always"
            )),
            array(
                'priority' => 1002,
            ));

        $this->add(array(
            'name' => 'MYObjectID',
            'type' => 'text',
            'attributes' => array(
                'id' => '_objectID',
                'placeholder' => 'Object ID'
            ),
            'options' => array(
                'label' => 'Object ID',
                'help' => "ID of the transaction"
            )),
            array(
                'priority' => 1001,
            ));
    }


}
