<?php

namespace Kotka\Form;

use Kotka\Stdlib\Hydrator\Reflection;
use Kotka\Stdlib\Hydrator\Strategy\DateTimeStrategy;
use Kotka\Triple\PUUBranch as Branch;
use Zend\Form\Form;
use Zend\InputFilter\InputFilterProviderInterface;

/**
 * Class PUUBranch
 * @package Kotka\Form
 */
class PUUBranch extends Form implements InputFilterProviderInterface
{

    /**
     * Creates the form with all the necessary fields in it
     */
    public function init()
    {
        $this
            ->setHydrator(new Reflection())
            ->setObject(new Branch());
    }

    public function postInit()
    {
        $this->remove('subject');
        $dateStrategy = new DateTimeStrategy();
        $dateStrategy->setOptions(array(
            'format' => 'Y-m-d'
        ));
        $this->hydrator->addStrategy('PUUDate', $dateStrategy);
    }

    /**
     * Should return an array specification compatible with
     * {@link Zend\InputFilter\Factory::createInputFilter()}.
     *
     * @return array
     */
    public function getInputFilterSpecification()
    {
        return array(
            'PUUExists' => array(
                'required' => false,
                'continue_if_empty' => true,
                'allow_empty' => true,
                'filters' => array(
                    array(
                        'name' => 'boolean'
                    )
                )
            ),
            'PUUAccessionID' => array(
                'require' => true
            )
        );
    }
}
