<?php

namespace Kotka\Form;

use Zend\Form\Form;
use Zend\InputFilter\InputFilterProviderInterface;

/**
 * Class SearchTransaction is the form used in loan index
 * @package Kotka\Form
 */
class SearchTransaction extends Form implements InputFilterProviderInterface
{
    /**
     * Creates the form with all the necessary fields in it
     */
    public function init()
    {
        parent::__construct('form_loans');
        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->add(array(
            'name' => 'Owner',
            'type' => 'Kotka\Form\Element\OwnerOrganization',
            'options' => array(
                'empty_option' => 'Select'
            ),
            'attributes' => array(
                'onchange' => 'this.form.submit()'
            )
        ));

        $this->add(array(
            'name' => 'Type',
            'type' => 'DatabaseSelect',
            'options' => array(
                'empty_option' => 'Select',
                'field' => 'HRA.transactionType'
            ),
            'attributes' => array(
                'onchange' => 'this.form.submit()'
            )
        ));
    }

    /**
     * Should return an array specification compatible with
     * {@link Zend\InputFilter\Factory::createInputFilter()}.
     *
     * @return array
     */
    public function getInputFilterSpecification()
    {
        return array(
            'owner' => array(
                'required' => false,
                'validators' => array(
                    array(
                        'name' => 'UserInOrganization',
                        'break_chain_on_failure' => true,
                    ),
                )
            ),
            'type' => array('required' => false),
        );
    }
}
