<?php

namespace Kotka\InputFilter;

use Kotka\Validator\RequireWithThis;
use Zend\InputFilter\CollectionInputFilter;

class HRATransaction extends BaseInputFilter
{
    protected $specimenFilter;

    public function init()
    {
        $this->add(array(
            'name' => 'HRBAway',
            'required' => false,
            'validators' => array(
                array(
                    'name' => 'Kotka\Validator\UniqueArrayContent',
                    'options' => [
                        'delimiter' => ','
                    ]
                )
            )
        ));
        $this->add(array(
            'name' => 'HRBDamaged',
            'required' => false,
            'validators' => array(
                array(
                    'name' => 'Kotka\Validator\UniqueArrayContent',
                    'options' => [
                        'delimiter' => ','
                    ]
                )
            )
        ));
        $this->add(array(
            'name' => 'HRBMissing',
            'required' => false,
            'validators' => array(
                array(
                    'name' => 'Kotka\Validator\UniqueArrayContent',
                    'options' => [
                        'delimiter' => ','
                    ]
                )
            )
        ));
        $this->add(array(
            'name' => 'HRBReturned',
            'required' => false,
            'validators' => array(
                array(
                    'name' => 'Kotka\Validator\UniqueArrayContent',
                    'options' => [
                        'delimiter' => ','
                    ]
                )
            )
        ));
        $this->add(array(
            'name' => 'HRACorrespondentOrganization',
            'required' => true
        ));
        $this->add(array(
            'name' => 'HRATransactionType',
            'required' => true
        ));
        $this->add(array(
            'name' => 'HRATransactionStatus',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRAGeneticResourceAcquisitionDate',
            'required' => false
        ));
        $this->add([
            'name' => 'HRAAvailableForGeneticResearch',
            'required' => false,
            'validators' => [
                [
                    'name' => 'InDatabaseSelect',
                    'options' => array(
                        'field' => 'HRA.availableForGeneticResearch'
                    )
                ],
                [
                    'name' => 'RequireWithThis',
                    'options' => array(
                        'field' => 'HRAGeneticResourceRightsAndObligations',
                        'when_contains' => 'HRA.availableForGeneticResearchWithRestrictions',
                        'messages' => array(
                            RequireWithThis::MISSING => 'Rights and obligations have to be filled when "with restrictions" is selected.'
                        ),
                    ),
                ]
            ]
        ]);
        $this->add(array(
            'name' => 'HRATransactionSent',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRATransactionReturned',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRADueDate',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRAReceiptReturned',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRBAwayOther',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRBReturnedOther',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRBMissingOther',
            'required' => false
        ));
        $this->add(array(
            'name' => 'HRBDamagedOther',
            'required' => false
        ));

        $this->add([
            'name' => 'HRAAvailableForGeneticResearch',
            'required' => false,
            'continue_if_empty' => true,
            'validators' => [
                [
                    'name' => 'HasIRCCChecks'
                ]
            ]
        ]);

        $this->add([
            'name' => 'HRAIRCC',
            'required' => false,
            'validators' => [
                [
                    'name' => 'IircNumber'
                ]
            ]
        ]);

        $permitFilter = $this
            ->getServiceLocator()
            ->getServiceLocator()
            ->get('InputFilterManager')
            ->get('Kotka\InputFilter\HRAPermit');

        $collectionContainerInputFilter = new CollectionInputFilter();
        $collectionContainerInputFilter->setInputFilter($permitFilter);
        $this->add($collectionContainerInputFilter, 'HRAPermit');

        parent::init();

    }

}