<?php

namespace LajiStore\ApiHistory\Factory;

use Interop\Container\ContainerInterface;
use Interop\Container\Exception\ContainerException;
use LajiStore\ApiHistory\Listener\SendApiHistoryResponseListener;
use Zend\Http\Response as HttpResponse;
use Zend\ServiceManager\Exception\ServiceNotCreatedException;
use Zend\ServiceManager\Exception\ServiceNotFoundException;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class SendApiHistoryResponseListenerFactory implements FactoryInterface
{
    /**
     * {@inheritDoc}
     * @return SendApiHistoryResponseListener
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        return $this($serviceLocator, SendApiHistoryResponseListener::class);
    }

    /**
     * Create an object
     *
     * @param  ContainerInterface $container
     * @param  string $requestedName
     * @param  null|array $options
     * @return object
     * @throws ServiceNotFoundException if unable to resolve the service.
     * @throws ServiceNotCreatedException if an exception is raised when
     *     creating a service.
     * @throws ContainerException if any other error occurs
     */
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        return new SendApiHistoryResponseListener();
    }
}
