CREATE SEQUENCE  "LAJISTORE_SEQ"  INCREMENT BY 1 CACHE 2;

CREATE TABLE LAJI_DOCUMENT
(
  "ID" VARCHAR2(100 BYTE) NOT NULL,
  "DATA" CLOB,
  "TYPE" VARCHAR2(25 BYTE) NOT NULL,
  "VERSION" NUMBER DEFAULT 1 NOT NULL,
  "API_VERSION" NUMBER,
  "SEQUENCE" NUMBER DEFAULT 0 NOT NULL,
  "SOURCE" VARCHAR2(25 BYTE) NOT NULL,
  "CREATED" DATE DEFAULT sysdate NOT NULL,
  "EDITED" DATE DEFAULT sysdate NOT NULL,
  CONSTRAINT LD_PK PRIMARY KEY (ID, SOURCE),
  CONSTRAINT "LD_JSON_DATA" CHECK (data IS JSON)
  );

CREATE TABLE LAJI_DOCUMENT_HISTORY
(
  "ID" VARCHAR2(100 BYTE) NOT NULL,
  "DATA" CLOB,
  "TYPE" VARCHAR2(25 BYTE) NOT NULL,
  "VERSION" NUMBER,
  "API_VERSION" NUMBER,
  "SEQUENCE" NUMBER,
  "SOURCE" VARCHAR2(25 BYTE) NOT NULL,
  "CREATED" DATE DEFAULT sysdate NOT NULL,
  "DELETED" DATE DEFAULT sysdate NOT NULL,
  "EDITED" DATE DEFAULT sysdate NOT NULL,
  CONSTRAINT LAJI_DOCUMENT_HIST_PK PRIMARY KEY (ID, SOURCE, VERSION),
  CONSTRAINT "LAJI_DOCUMENT_HIST_JSON_DATA" CHECK (data IS JSON)
);

-- index source type combination
CREATE INDEX IX_LD_SOURCE_TYPE
  ON LAJI_DOCUMENT (SOURCE, TYPE);

CREATE INDEX IX_LD_DEVICE_ID
  ON LAJI_DOCUMENT (json_value(data, '$.deviceID'));


CREATE INDEX IX_LD_ROOT_ID
  ON LAJI_DOCUMENT (json_value(data, '$.rootID'));

CREATE INDEX IX_LD_INDIVIDUAL_ID
  ON LAJI_DOCUMENT (json_value(data, '$.individualID'));

CREATE INDEX IX_LD_DEVICE_MANUFACTURER_ID
  ON LAJI_DOCUMENT (json_value(data, '$.deviceManufacturerID'));

CREATE INDEX IX_LD_USER_ID
  ON LAJI_DOCUMENT (json_value(data, '$.userID'));

CREATE INDEX IX_LD_CREATOR
  ON LAJI_DOCUMENT (json_value(data, '$.creator'));

CREATE INDEX IX_LD_DELETED
  ON LAJI_DOCUMENT (json_value(data, '$.deleted'));

-- TODO: these indexes need to be revisited when the oracle patch is applied
-- index for document gathering datetimebegin
CREATE INDEX IX_LAJI_GATHERING_BEGIN
  ON LAJI_DOCUMENT (to_timestamp_tz(json_value(data, '$.gatherings[*].dateTimeBegin'),'YYYY-MM-DD"T"HH24:MI:SSTZH:TZM'));

-- index for document gathering datetimeend
CREATE INDEX IX_LAJI_GATHERING_END
  ON LAJI_DOCUMENT (to_timestamp_tz(json_value(data, '$.gatherings[*].dateTimeEnd'),'YYYY-MM-DD"T"HH24:MI:SSTZH:TZM'));

-- trigger to handle version and history data
create or replace TRIGGER TR_LAJI_DOCUMENT_HISTORY
BEFORE UPDATE OR DELETE
ON LAJI_DOCUMENT
FOR EACH ROW
  BEGIN
    if UPDATING then
      :new.version := :old.version + 1;
      :new.edited := sysdate;
    end if;
    INSERT INTO laji_document_history
    (
      id,
      data,
      type,
      version,
      api_version,
      sequence,
      source,
      created,
      edited,
      deleted
    )
    VALUES
      (
        :old.id,
        :old.data,
        :old.type,
        :old.version,
        :old.api_version,
        :old.sequence,
        :old.source,
        :old.created,
        :old.edited,
        SYSDATE
      );
  END TR_LAJI_DOCUMENT_HISTORY;

-- update 26.1.2017
CREATE SEQUENCE  "NAMED_PLACE_SEQ"  INCREMENT BY 1 CACHE 2;

-- update 20.2.2017
CREATE SEQUENCE "ANNOTATION_SEQ"  INCREMENT BY 1 CACHE 2;

-- update 31.3.2017
CREATE SEQUENCE "FORM_PERMISSION_SEQ"  INCREMENT BY 1 CACHE 2;

-- update 19.7.2017
CREATE SEQUENCE "NOTIFICATION_SEQ"  INCREMENT BY 1 CACHE 2;

-- update 6.3.2018
CREATE INDEX IX_LD_IS_TEMPLATE
  ON laji_document (json_value(data, '$.isTemplate' DEFAULT 'false' ON ERROR));


-- search table after 24.7. changes
CREATE TABLE "LAJISTORE_STAGING"."DOCUMENT_SEARCH"
(	"ID" VARCHAR2(100 BYTE) NOT NULL ENABLE,
   "SOURCE" VARCHAR2(25 BYTE) NOT NULL ENABLE,
   "YEARSTART" NUMBER(4,0),
   "YEAREND" NUMBER(4,0),
   "DATESTART" NUMBER(8,0),
   "DATEEND" NUMBER(8,0),
   "CREATOR" VARCHAR2(100 BYTE),
   "EDITOR" VARCHAR2(100 BYTE),
   "EDITORS" VARCHAR2(100 BYTE),
   "OWNERS" VARCHAR2(100 BYTE),
   "DEVICEID" VARCHAR2(100 BYTE),
   "INDIVIDUALID" VARCHAR2(100 BYTE),
   "NAMEDPLACEID" VARCHAR2(100 BYTE),
   "COLLECTIONID" VARCHAR2(100 BYTE),
   "ISTEMPLATE" NUMBER(1,0)
) SEGMENT CREATION IMMEDIATE
PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
NOCOMPRESS LOGGING
STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;

CREATE INDEX "LAJISTORE_STAGING"."T_SEARCH_COLLECTION_SOURCE_IDX" ON "LAJISTORE_STAGING"."DOCUMENT_SEARCH" ("COLLECTIONID", "SOURCE", "ISTEMPLATE")
PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;

CREATE INDEX "LAJISTORE_STAGING"."T_SEARCH_OWNER_SOURCE_IDX" ON "LAJISTORE_STAGING"."DOCUMENT_SEARCH" ("OWNERS", "SOURCE", "ISTEMPLATE")
PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;
